/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.ItemEntry;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.betterx.bclib.config.PathConfig;
import org.betterx.bclib.registry.BlockRegistry;
import org.betterx.bclib.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class ComplexMaterial {
    private static final Map<class_2960, List<RecipeEntry>> RECIPE_ENTRIES = Maps.newHashMap();
    private static final Map<class_2960, List<BlockEntry>> BLOCK_ENTRIES = Maps.newHashMap();
    private static final Map<class_2960, List<ItemEntry>> ITEM_ENTRIES = Maps.newHashMap();
    private static final List<ComplexMaterial> MATERIALS = Lists.newArrayList();
    private final List<RecipeEntry> defaultRecipeEntries = Lists.newArrayList();
    private final List<BlockEntry> defaultBlockEntries = Lists.newArrayList();
    private final List<ItemEntry> defaultItemEntries = Lists.newArrayList();
    private final Map<String, class_6862<class_2248>> blockTags = Maps.newHashMap();
    private final Map<String, class_6862<class_1792>> itemTags = Maps.newHashMap();
    private final Map<String, class_2248> blocks = Maps.newHashMap();
    private final Map<String, class_1792> items = Maps.newHashMap();
    protected final String baseName;
    protected final String modID;
    protected final String receipGroupPrefix;

    public ComplexMaterial(String modID, String baseName, String receipGroupPrefix) {
        this.baseName = baseName;
        this.modID = modID;
        this.receipGroupPrefix = receipGroupPrefix;
        MATERIALS.add(this);
    }

    public ComplexMaterial init(BlockRegistry blocksRegistry, ItemRegistry itemsRegistry, PathConfig recipeConfig) {
        this.initTags();
        class_4970.class_2251 blockSettings = this.getBlockSettings();
        class_1792.class_1793 itemSettings = this.getItemSettings(itemsRegistry);
        this.initDefault(blockSettings, itemSettings);
        this.getBlockEntries().forEach(entry -> {
            class_2248 block = entry.init(this, blockSettings, blocksRegistry);
            this.blocks.put(entry.getSuffix(), block);
        });
        this.getItemEntries().forEach(entry -> {
            class_1792 item = entry.init(this, itemSettings, itemsRegistry);
            this.items.put(entry.getSuffix(), item);
        });
        this.initDefaultRecipes();
        this.getRecipeEntries().forEach(entry -> entry.init(this, recipeConfig));
        this.initFlammable(FlammableBlockRegistry.getDefaultInstance());
        return this;
    }

    protected abstract void initDefault(class_4970.class_2251 var1, class_1792.class_1793 var2);

    protected void initTags() {
    }

    protected void initDefaultRecipes() {
    }

    protected void initFlammable(FlammableBlockRegistry registry) {
    }

    protected void addBlockTag(class_6862<class_2248> tag) {
        String key = tag.comp_327().method_12832().replace(this.getBaseName() + "_", "");
        this.blockTags.put(key, tag);
    }

    protected void addItemTag(class_6862<class_1792> tag) {
        String key = tag.comp_327().method_12832().replace(this.getBaseName() + "_", "");
        this.itemTags.put(key, tag);
    }

    @Nullable
    public class_6862<class_2248> getBlockTag(String key) {
        return this.blockTags.get(key);
    }

    @Nullable
    public class_6862<class_1792> getItemTag(String key) {
        return this.itemTags.get(key);
    }

    @Nullable
    public class_2248 getBlock(String key) {
        return this.blocks.get(key);
    }

    @Nullable
    public class_1792 getItem(String key) {
        return this.items.get(key);
    }

    protected abstract class_4970.class_2251 getBlockSettings();

    protected class_1792.class_1793 getItemSettings(ItemRegistry registry) {
        return registry.makeItemSettings();
    }

    private Collection<BlockEntry> getBlockEntries() {
        ArrayList result = Lists.newArrayList(this.defaultBlockEntries);
        List<BlockEntry> entries = BLOCK_ENTRIES.get(this.getMaterialID());
        if (entries != null) {
            result.addAll(entries);
        }
        return result;
    }

    private Collection<ItemEntry> getItemEntries() {
        ArrayList result = Lists.newArrayList(this.defaultItemEntries);
        List<ItemEntry> entries = ITEM_ENTRIES.get(this.getMaterialID());
        if (entries != null) {
            result.addAll(entries);
        }
        return result;
    }

    private Collection<RecipeEntry> getRecipeEntries() {
        ArrayList result = Lists.newArrayList(this.defaultRecipeEntries);
        List<RecipeEntry> entries = RECIPE_ENTRIES.get(this.getMaterialID());
        if (entries != null) {
            result.addAll(entries);
        }
        return result;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getModID() {
        return this.modID;
    }

    public abstract class_2960 getMaterialID();

    public Collection<class_2248> getBlocks() {
        return this.blocks.values();
    }

    public Collection<class_1792> getItems() {
        return this.items.values();
    }

    protected void addBlockEntry(BlockEntry entry) {
        this.defaultBlockEntries.add(entry);
    }

    protected void replaceOrAddBlockEntry(BlockEntry entry) {
        int pos = this.defaultBlockEntries.indexOf(entry);
        if (pos >= 0) {
            this.defaultBlockEntries.remove(entry);
        }
        this.addBlockEntry(entry);
    }

    protected void addItemEntry(ItemEntry entry) {
        this.defaultItemEntries.add(entry);
    }

    protected void addRecipeEntry(RecipeEntry entry) {
        this.defaultRecipeEntries.add(entry);
    }

    public static void addBlockEntry(class_2960 materialName, BlockEntry entry) {
        ArrayList entries = BLOCK_ENTRIES.get(materialName);
        if (entries == null) {
            entries = Lists.newArrayList();
            BLOCK_ENTRIES.put(materialName, entries);
        }
        entries.add(entry);
    }

    public static void addItemEntry(class_2960 materialName, ItemEntry entry) {
        ArrayList entries = ITEM_ENTRIES.get(materialName);
        if (entries == null) {
            entries = Lists.newArrayList();
            ITEM_ENTRIES.put(materialName, entries);
        }
        entries.add(entry);
    }

    public static void addRecipeEntry(class_2960 materialName, RecipeEntry entry) {
        ArrayList entries = RECIPE_ENTRIES.get(materialName);
        if (entries == null) {
            entries = Lists.newArrayList();
            RECIPE_ENTRIES.put(materialName, entries);
        }
        entries.add(entry);
    }

    public static Collection<ComplexMaterial> getAllMaterials() {
        return MATERIALS;
    }
}

